#!/bin/python3

#Answers the question: "Are there files in one directory tree that are not in the other"
#Does not take into account the relative position of files when comparing directory trees

from os import listdir
from os.path import isfile, join, islink, exists, getsize
import sys
from fsToolsLib import findAllFilesRecursively, findFilesUniqueToListOne
import argparse


parser = argparse.ArgumentParser()
parser.add_argument('pathOne')
parser.add_argument('pathTwo')
args = parser.parse_args()

pathOne = args.pathOne
pathTwo = args.pathTwo

pathOneFileInfos = findAllFilesRecursively(pathOne)
pathTwoFileInfos= findAllFilesRecursively(pathTwo)


filesUniqueToPathOne = findFilesUniqueToListOne(pathOneFileInfos, pathTwoFileInfos)
for fileInfo in filesUniqueToPathOne:
    print(fileInfo.getPath() + " was not found (or different) in " + pathTwo)


filesUniqueToPathTwo = findFilesUniqueToListOne(pathTwoFileInfos, pathOneFileInfos)
for fileInfo in filesUniqueToPathTwo:
    print(fileInfo.getPath() + " was not found (or different) in " + pathOne)